<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AllegroUser
 *
 * @ORM\Table(name="allegro_user")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\AllegroUserRepository")
 */
class AllegroUser
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer $user_id
     *
     * @ORM\Column(name="user_id", type="integer")
     */
    private $user_id;

    /**
     * @var string $name
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var integer $rating
     *
     * @ORM\Column(name="rating", type="integer")
     */
    private $rating;

    /**
     * @ORM\OneToMany(targetEntity="AllegroCategoryItem", mappedBy="user")
     */
    private $allegroCategoryItems;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->allegroCategoryItems = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set user_id
     *
     * @param integer $userId
     * @return AllegroUser
     */
    public function setUserId($userId)
    {
        $this->user_id = $userId;
    
        return $this;
    }

    /**
     * Get user_id
     *
     * @return integer 
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return AllegroUser
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set rating
     *
     * @param integer $rating
     * @return AllegroUser
     */
    public function setRating($rating)
    {
        $this->rating = $rating;
    
        return $this;
    }

    /**
     * Get rating
     *
     * @return integer 
     */
    public function getRating()
    {
        return $this->rating;
    }

    /**
     * Add allegroCategoryItems
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems
     * @return AllegroUser
     */
    public function addAllegroCategoryItem(\Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems)
    {
        $this->allegroCategoryItems[] = $allegroCategoryItems;
    
        return $this;
    }

    /**
     * Remove allegroCategoryItems
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems
     */
    public function removeAllegroCategoryItem(\Import\ApiBundle\Entity\AllegroCategoryItem $allegroCategoryItems)
    {
        $this->allegroCategoryItems->removeElement($allegroCategoryItems);
    }

    /**
     * Get allegroCategoryItems
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getAllegroCategoryItems()
    {
        return $this->allegroCategoryItems;
    }
}
